#include <Adafruit_NeoPixel.h>

#define PIN 3

// Parameter 1 = number of pixels in strip
// Parameter 2 = pin number (most are valid)
// Parameter 3 = pixel type flags, add together as needed:
//   NEO_RGB     Pixels are wired for RGB bitstream
//   NEO_GRB     Pixels are wired for GRB bitstream
//   NEO_KHZ400  400 KHz bitstream (e.g. FLORA pixels)
//   NEO_KHZ800  800 KHz bitstream (e.g. High Density LED strip)
Adafruit_NeoPixel strip = Adafruit_NeoPixel(25, PIN, NEO_GRB + NEO_KHZ800);

int pinLight        = A5;
bool __GFlgMove     = 1;
bool __GFlgAllOff   = 0;

int LIGHT_HIGH         = 150;
int LIGHT_LOW          = 100;

void lightProc()
{
    unsigned long value = 0;
    for(int i=0; i<128; i++)
    {
        value += analogRead(pinLight);
    }
    value = value>>7;
    
    Serial.println(value);

    if(!__GFlgMove && value < LIGHT_LOW)__GFlgMove = 1;
    if(__GFlgMove && value > LIGHT_HIGH)__GFlgMove  = 0;

    if(!__GFlgMove && !__GFlgAllOff)        // turn off all
    {
        __GFlgAllOff = 1;
        for(unsigned char i=0; i< strip.numPixels(); i++) 
        {
            strip.setPixelColor(i, 0, 0, 0);
        }
        strip.show();
    }
    
    if(__GFlgMove && __GFlgAllOff)
    {
        __GFlgAllOff = 0;
    }
}

void move()
{
    if(!__GFlgMove)return;
    
    static uint16_t i=0;
    static uint16_t j=0;
    
    for(i=0; i< strip.numPixels(); i++) 
    {
        strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
    }
    strip.show();
    delay(20);
    
    j++;
    if(j>=256*5)j=0;

    /*
    for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
        for(i=0; i< strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
        }
        strip.show();
        delay(wait);
    }*/
}

void setup() {
    Serial.begin(115200);
    strip.begin();
    strip.show(); // Initialize all pixels to 'off'
}

void loop()
{
    //rainbowCycle(20);
    move();
    
    lightProc();
}

// Fill the dots one after the other with a color
void colorWipe(uint32_t c, uint8_t wait) {
    for(uint16_t i=0; i<strip.numPixels(); i++) {
        strip.setPixelColor(i, c);
        strip.show();
        delay(wait);
    }
}

void rainbow(uint8_t wait) {
    uint16_t i, j;

    for(j=0; j<256; j++) {
        for(i=0; i<strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel((i+j) & 255));
        }
        strip.show();
        delay(wait);
    }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
    uint16_t i, j;

    for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
        for(i=0; i< strip.numPixels(); i++) {
            strip.setPixelColor(i, Wheel(((i * 256 / strip.numPixels()) + j) & 255));
        }
        strip.show();
        delay(wait);
    }
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t Wheel(byte WheelPos) {
    if(WheelPos < 85) {
        return strip.Color(WheelPos * 3, 255 - WheelPos * 3, 0);
    } else if(WheelPos < 170) {
        WheelPos -= 85;
        return strip.Color(255 - WheelPos * 3, 0, WheelPos * 3);
    } else {
        WheelPos -= 170;
        return strip.Color(0, WheelPos * 3, 255 - WheelPos * 3);
    }
}
